/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registries;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBarracuda;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBear;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBoar;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCoyote;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCrab;
import dev.itsmeow.betteranimalsplus.common.entity.EntityFeralWolf;
import dev.itsmeow.betteranimalsplus.common.entity.EntityLamprey;
import dev.itsmeow.betteranimalsplus.common.entity.EntityOctopus;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPiranha;
import dev.itsmeow.betteranimalsplus.common.entity.EntitySquirrel;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import dev.itsmeow.betteranimalsplus.common.fabric.CommonEventHandlerImpl;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.mixin.MobAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2619;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class CommonEventHandler {
    public static final Set<Predicate<class_1297>> NO_ATTACKED_DROPS = new HashSet<Predicate<class_1297>>();
    public static final Multimap<class_2960, class_2960> LOOT_TABLE_INJECTIONS;

    public static void init() {
        EntityEvent.LIVING_DEATH.register(CommonEventHandler::entityDeath);
        EntityEvent.LIVING_HURT.register(CommonEventHandler::entityAttack);
        EntityEvent.ADD.register(CommonEventHandler::entityAdd);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(CommonEventHandler::rightClickBlock);
        InteractionEvent.RIGHT_CLICK_ITEM.register(CommonEventHandler::rightClickItem);
        CommonEventHandler.registerPlatformEvents();
    }

    public static EventResult entityDeath(class_1309 entity, class_1282 source) {
        if (source.method_5526() instanceof EntityBoar && ModEntities.BOAR.getCustomConfiguration().getBoolean("nerf_options/breed_from_kill")) {
            EntityBoar boar = (EntityBoar)source.method_5526();
            boar.method_6480(null);
            class_2338 p = boar.method_24515();
            boar.field_6002.method_8406((class_2394)class_2398.field_11201, (double)p.method_10263(), (double)p.method_10264(), (double)p.method_10260(), 0.0, (double)0.05f, 0.0);
        } else if (source.method_5526() instanceof class_3222) {
            class_3222 player = (class_3222)source.method_5526();
            if (entity instanceof EntityBear || entity instanceof class_1456) {
                if (player.method_6047().method_7960()) {
                    ModTriggers.PUNCH_BEAR_DEATH.trigger(player);
                }
            } else if (entity instanceof EntitySquirrel && !player.method_14236().method_12882(player.field_13995.method_3851().method_12896(new class_2960("betteranimalsplus:squirrel_kill_100"))).method_740()) {
                CommonEventHandler.setSquirrelKills((class_1657)player, oldValue -> {
                    int newValue = oldValue + 1;
                    if (newValue > 100) {
                        newValue = 1;
                    }
                    if (ModTriggers.SQUIRREL_KILL_TRIGGERS.containsKey(newValue)) {
                        ModTriggers.SQUIRREL_KILL_TRIGGERS.get(newValue).trigger(player);
                    }
                    return newValue;
                });
            }
        } else if (source.method_5529() instanceof EntityOctopus) {
            class_1657 p;
            EntityOctopus octo = (EntityOctopus)source.method_5529();
            if (octo.friend != null && (p = octo.field_6002.method_18470(octo.friend)) instanceof class_3222 && p.method_6124() == entity) {
                ModTriggers.OCTOPUS_SAVE_PLAYER.trigger((class_3222)octo.field_6002.method_18470(octo.friend));
            }
        }
        if (source.method_5526() instanceof IHaveHunger) {
            ((IHaveHunger)source.method_5526()).resetHunger();
        }
        return EventResult.pass();
    }

    public static EventResult rightClickBlock(class_1657 player, class_1268 hand, class_2338 pos, class_2350 direction) {
        class_2586 te;
        if (player.field_6002.method_8320(pos).method_26204() == class_2246.field_10223 && player instanceof class_3222 && (te = player.field_6002.method_8321(pos)) instanceof class_2619) {
            class_2619 box = (class_2619)te;
            class_1792 held = player.method_5998(hand).method_7909();
            class_1792 boxItem = box.method_11275().method_7909();
            boolean added = box.method_11275().method_7960();
            CommonEventHandler.onDiskUse(added, (class_3222)player, added ? held : boxItem);
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<class_1799> rightClickItem(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_2960 reg = Registries.get((String)"betteranimalsplus").get(class_2378.field_25108).getId((Object)stack.method_7909());
        if (reg != null && reg.method_12832().equals("portable_jukebox") && player instanceof class_3222 && stack.method_7941("Disc") != null) {
            class_1792 item = class_1799.method_7915((class_2487)stack.method_7941("Disc")).method_7909();
            CommonEventHandler.onDiskUse(player.method_18276(), (class_3222)player, item);
        }
        return CompoundEventResult.pass();
    }

    private static void onDiskUse(boolean added, class_3222 player, class_1792 item) {
        block5: {
            if (!(item instanceof class_1813)) break block5;
            if (added) {
                List crabs = player.method_5770().method_18467(EntityCrab.class, player.method_5829().method_1014(50.0));
                if (crabs.size() > 0) {
                    ModTriggers.CRAB_DANCE.trigger(player);
                }
                for (EntityCrab crab : crabs) {
                    crab.crabRave();
                }
            } else {
                List crabs = player.method_5770().method_18467(EntityCrab.class, player.method_5829().method_1014(100.0));
                for (EntityCrab crab : crabs) {
                    crab.unCrabRave();
                }
            }
        }
    }

    public static EventResult entityAttack(class_1309 entity, class_1282 source, float damage) {
        if (source.method_5529() instanceof class_3222 && (entity instanceof EntityBear || entity instanceof class_1456) && ((class_3222)source.method_5529()).method_6047().method_7960()) {
            ModTriggers.PUNCH_BEAR.trigger((class_3222)source.method_5529());
        }
        return EventResult.pass();
    }

    public static void modifyDropsList(Collection<class_1542> drops, class_1282 source, class_1309 entity) {
        if (!(source.method_5529() == null || entity instanceof class_1657 || !NO_ATTACKED_DROPS.stream().anyMatch(predicate -> predicate.test(source.method_5529())) || source.method_5529() instanceof IBucketable && ((IBucketable)source.method_5529()).isFromContainer())) {
            drops.clear();
        }
    }

    public static EventResult entityAdd(class_1297 entity, class_1937 level) {
        if (entity instanceof class_1439) {
            ((MobAccessor)entity).getTargetSelector().method_6277(3, (class_1352)new class_1400((class_1308)((class_1439)entity), EntityFeralWolf.class, 5, false, false, e -> !((EntityFeralWolf)e).method_6181()));
            ((MobAccessor)entity).getTargetSelector().method_6277(3, (class_1352)new class_1400((class_1308)((class_1439)entity), EntityCoyote.class, 5, false, false, e -> !((EntityCoyote)e).method_6181() && !((EntityCoyote)e).isDaytime()));
        }
        return EventResult.pass();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatformEvents() {
        CommonEventHandlerImpl.registerPlatformEvents();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(class_1657 player, int kills) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(class_1657 player, Function<Integer, Integer> mutator) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (Function<Integer, Integer>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getSquirrelKills(class_1657 player) {
        return CommonEventHandlerImpl.getSquirrelKills(player);
    }

    static {
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityLamprey);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntitySharkBase);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityBarracuda);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityPiranha);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityOctopus && ((EntityOctopus)e).friend == null);
        LOOT_TABLE_INJECTIONS = MultimapBuilder.hashKeys().hashSetValues().build();
        IVariant v = ModEntities.FERAL_WOLF.getVariantForName("snowy").orElse(null);
        if (v instanceof EntityFeralWolf.WolfVariant) {
            EntityFeralWolf.WolfVariant variant = (EntityFeralWolf.WolfVariant)v;
            LOOT_TABLE_INJECTIONS.put((Object)class_1299.field_6055.method_16351(), (Object)variant.getLootTable());
        }
        LOOT_TABLE_INJECTIONS.put((Object)class_1299.field_6114.method_16351(), (Object)ModLootTables.SQUID);
    }
}

